<?php
$slug = tenant_slug();
$csrf = csrf_token();
$user = $user ?? [];
$ok  = $ok  ?? null;
$err = $err ?? null;
?>

<div class="flex items-start justify-between gap-4">
  <div>
    <h2 class="text-lg font-semibold">Kullanıcı Ayarları</h2>
    <p class="mt-1 text-sm text-slate-500 dark:text-slate-400">
      Hesap bilgilerini buradan yönetebilirsin.
    </p>
  </div>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-4 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>

<?php if (!empty($err)): ?>
  <div class="mt-4 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<form method="post" action="<?= e(base_path('/'.$slug.'/profile')) ?>" class="mt-6 space-y-6">
  <input type="hidden" name="csrf" value="<?= e($csrf) ?>">

  <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div>
      <label class="text-sm font-medium">Ad Soyad</label>
      <input name="name" value="<?= e((string)($user['name'] ?? '')) ?>"
        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
    </div>

    <div>
      <label class="text-sm font-medium">E-posta</label>
      <input name="email" value="<?= e((string)($user['email'] ?? '')) ?>"
        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
    </div>

    <div>
      <label class="text-sm font-medium">Rol</label>
      <input value="<?= e((string)($user['role'] ?? '')) ?>" readonly
        class="mt-2 w-full rounded-xl border border-slate-200 bg-slate-50 px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-900/40">
    </div>

    <div>
      <label class="text-sm font-medium">Dil (Kullanıcı)</label>
      <?php $ld = (string)($user['locale'] ?? ''); ?>
      <select name="locale"
        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
        <option value="" <?= $ld===''?'selected':'' ?>>Firma ayarını kullan</option>
        <option value="tr" <?= $ld==='tr'?'selected':'' ?>>Türkçe</option>
        <option value="en" <?= $ld==='en'?'selected':'' ?>>English</option>
      </select>
    </div>

    <div>
      <label class="text-sm font-medium">Tema (Kullanıcı)</label>
      <?php $tm = (string)($user['theme_mode'] ?? ''); ?>
      <select name="theme_mode"
        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
        <option value="" <?= $tm===''?'selected':'' ?>>Firma ayarını kullan</option>
        <option value="system" <?= $tm==='system'?'selected':'' ?>>Sistem</option>
        <option value="light"  <?= $tm==='light'?'selected':'' ?>>Açık</option>
        <option value="dark"   <?= $tm==='dark'?'selected':'' ?>>Koyu</option>
      </select>
    </div>
  </div>

  <div class="flex items-center justify-end gap-2 pt-2">
    <button type="submit"
      class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">
      Kaydet
    </button>
  </div>
</form>
